select   daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen,

         sum(daten.Jahr1) as "Jahressumme vor 5 Jahren",
         sum(daten.Jahr2) as "Jahressumme vor 4 Jahren",
         sum(daten.Jahr3) as "Jahressumme vor 3 Jahren",
         sum(daten.Jahr4) as "Jahressumme vor 2 Jahren",
         sum(daten.Jahr5) as "Jahressumme vor 1 Jahr"

from     (
         select   'Basiszahl 226.1' as "Bezeichnung",
                  isnull(k.kennzeichen,'(ohne)') as "Kuerzel",
                  isnull(k.bezeichnung,'(ohne)') as "Vorgangskennzeichen",

                  count(distinct(case when year(m.bisdatum) = year(getdate())-5
                                      then h.massnahme else null end)) as "Jahr1",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-4
                                      then h.massnahme else null end)) as "Jahr2",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-3
                                      then h.massnahme else null end)) as "Jahr3",   
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-2
                                      then h.massnahme else null end)) as "Jahr4",
                             
                  count(distinct(case when year(m.bisdatum) = year(getdate())-1
                                      then h.massnahme else null end)) as "Jahr5"   
                                      
         from     n_vorgang v inner join n_vorgmassnahme h on v.vorgangsnummer = h.vorgang
                              inner join n_stat8a s on h.massnahme = s.massnahmennummer      
                              inner join n_massnahme m on h.massnahme = m.massnahmennummer
                              left join n_kennz k on v.kennz_fk = k.lfdnr

         where    s.freigegeben = '1'
         and      s.ef18 in ('1','2')

         group by isnull(k.kennzeichen,'(ohne)'),
                  isnull(k.bezeichnung,'(ohne)')

         ) as daten
         
group by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen

order by daten.Bezeichnung,
         daten.Kuerzel,
         daten.Vorgangskennzeichen